import funkin.game.Character;
var nutcracker:FlxSprite = new FlxSprite(-350, -80);
nutcracker.frames = Paths.getFrames("stages/hiver/nutcracker");
nutcracker.animation.addByPrefix("appear", "nutcrackeranim", 24, false);
nutcracker.scale.set(0.7, 0.7);

var fireball:FlxSprite = new FlxSprite(0, -500);
fireball.frames = Paths.getFrames("stages/hiver/fireball");
fireball.animation.addByPrefix("shoot", "fireballanim", 24, false);
fireball.scrollFactor.set(0.5, 0.5);

var shoots:FlxSound;
shoots = FlxG.sound.load(Paths.sound("crackerofnuts"));

var title = new FlxSprite(0, 500);
title.loadGraphic("images/stages/hiver/sadistic.png");
title.antialiasing = true;
title.alpha = 0.001;

function postCreate()
{
	gf.alpha = 0.001;

	add(nutcracker);
	nutcracker.cameras = [camHUD2];
	add(fireball);
	nutcracker.visible = false;
	fireball.visible = false;

	title.cameras = [camHUD2];
	title.screenCenter();
	add(title);

}

var __timer:Float = 0;
var floating = false;
function update(elapsed:Float) {
	if (floating) {
	  __timer += elapsed; 
	  gf.x = (600+(15*Math.sin(__timer)));	
	  gf.y = (-150+(20*Math.cos(__timer*2)));
	}
}


function postUpdate(){
    if(curCameraTarget == 1){ defaultCamZoom = 1;} else { defaultCamZoom = 0.7; }
    
}
function onNoteHit(event) {
	if (event.character == strumLines.members[0].characters[0])
	{
		if (health > 0.1) event.healthGain += 0.02;
		if(FlxG.save.data.flashing_toggle)
		{
			camGame.shake(0.004, (Conductor.stepCrochet / 1000) * 1, null, true);
			camHUD.shake(0.005, (Conductor.stepCrochet / 1000) * 1, null, true);
		}
	}
}

function stepHit(step)
{
	switch (step)
	{
		case 260:
			FlxTween.tween(title, {alpha: 1}, (Conductor.stepCrochet / 1000) * 8);
		case 304:
			FlxTween.tween(title, {alpha: 0.001}, (Conductor.stepCrochet / 1000) * 8);
		case 768:
			FlxTween.tween(camHUD, {alpha: 0.001}, (Conductor.crochet / 1000) * 1, {ease: FlxEase.quadOut});
        case 832:
		    gf.alpha = 1;
			floating = true;
        case 848:
			FlxTween.tween(camHUD, {alpha: 1}, (Conductor.crochet / 1000) * 4, {ease: FlxEase.quadOut});
		
        case 1520:
			FlxTween.tween(camHUD, {alpha: 0.001}, (Conductor.crochet / 1000) * 1, {ease: FlxEase.quadOut});
		case 1524:
			floating = false;
		case 1528:
		    nutcracker.visible = true;
		    nutcracker.animation.play('appear');
			shoots.play(true);
        case 1544:
			FlxTween.tween(camHUD, {alpha: 1}, (Conductor.crochet / 1000) * 2, {ease: FlxEase.quadOut});
		case 1546:
			fireball.visible = true;
		    fireball.animation.play('shoot');
		case 1552:
			nutcracker.visible = false;
		case 1558:
			gf.alpha = 0.001;
		case 1562:
			fireball.visible = false;
		case 2608:
			camGame.visible = false;
			camHUD.visible = false;
	}
}
